package ru.yandex.crypta.clients.audience;

import com.fasterxml.jackson.databind.JsonNode;

public interface AudienceClient {
    JsonNode listSegments();

    JsonNode getSegment(String segmentId);

    AudienceListGrantsResponse listGrants(String segmentId);

    AudienceCreateGrantResponse createGrant(String segmentId, String userLogin, String userComment);

    AudienceDeleteResponse deleteGrant(String segmentId, String userLogin);

    AudienceDeleteResponse deleteSegment(String segmentId);

    JsonNode updateSegment(String segmentId, String name);

    JsonNode uploadSegmentFile(String login, boolean exportCryptaId);

    JsonNode confirmSegment(int segmentId, String segmentName, String login, boolean exportCryptaId);
}
