package ru.yandex.crypta.clients.audience;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AudienceListGrantsResponse {
    private List<AudienceUser> grants;

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class AudienceUser {
        private String user;
        private String comment;

        @JsonProperty("user_login")
        public String getUser() {
            return user;
        }

        public String getComment() {
            return comment;
        }
    }

    @JsonProperty("grants")
    public List<AudienceUser> getGrants() {
        return grants;
    }
}
