package ru.yandex.crypta.clients.bigb;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import yabs.proto.Profile;

import ru.yandex.ads.bsyeti.libs.counter_lib.proto.TCounterPack;

public interface BigbClient {
    JsonNode getBigbData(BigbIdType bigbIdType, String bigbIdValue);

    Profile getBigbDataProto(BigbIdType idType, String id);

    JsonNode getCommonProfile(CommonId commonId);

    JsonNode getEnhancedProfile(BigbIdType uidType, String uidValue, int matching, String cookie);

    JsonNode getUserSearchText(BigbIdType uidType, String uidValue, int matching, String cookie);

    JsonNode getUserSearchTextWithMatching(BigbIdType uidType, String uidValue, String cookie);

    JsonNode getUserCryptaHubs(BigbIdType uidType, String uidValue, String cookie);

    List<TCounterPack> getCounters(BigbIdType idType, String idValue, Collection<Integer> counters);
}
