package ru.yandex.crypta.clients.bigb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Replicates BigB QueryParams
 * https://a.yandex-team.ru/arc/trunk/arcadia/ads/bsyeti/eagle/collect/proto/query_params.proto?rev=r7821822#L35
 */
public enum BigbIdType {
    BIGB_UID("bigb-uid"),
    CRYPTA_ID("crypta-id"),
    PUID("puid"),
    GAID("gaid"),
    IDFA("idfa"),
    OAID("oaid"),
    IFV("ifv"),
    MM_DEVICE_ID("mm-device-id"),
    UUID("uuid"),
    DUID("duid"),
    ICOOKIE("icookie");

    final String value;

    BigbIdType(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static List<String> names() {
        return Stream.of(values())
                .map(BigbIdType::value)
                .collect(Collectors.toList());
    }

    public static Map<String, String> nameMap() {
        Map<String, String> nameMap = new HashMap<>();
        for (BigbIdType idType : BigbIdType.values()) {
            nameMap.put(idType.name(), idType.value());
        }

        return nameMap;
    }
}
