package ru.yandex.crypta.clients.bigb;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class Household {
    private long hhid;
    private int version;
    private int male;
    private int female;
    private int child;
    private int grand;
    private String income;
    private int numberOfBrowsers;
    private int numberOfIndividualDevices;
    private int numberOfCollectiveDevices;
    private int numberOfStationaryDevices;
    private int numberOfUnstationaryDevices;
    private int platformsDesktopBrowser;
    private int platformsMobileApp;
    private int platformsMobileBrowser;
    private int platformsSmartTv;
    private int platformsOther;
    private int osWin;
    private int osIos;
    private int osAndroid;
    private int osMacos;
    private int osOther;
    private float lat;
    private float lon;
    private int mainProfileMale;
    private int mainProfileFemale;
    private int mainProfileAge18;
    private int mainProfileAge1824;
    private int mainProfileAge2534;
    private int mainProfileAge3544;
    private int mainProfileAge4554;
    private int mainProfileAge55;
    private List<Integer> adhocs;
    private List<Integer> thirdPartyData;

    private static final Map<String, String> INCOMES;
    static {
        INCOMES = ImmutableMap.of(
            "00", "Unknown",
            "01", "A",
            "10", "B",
            "11", "C"
        );
    }

    private Household(String householdEncoded) {
        extractValues(householdEncoded);
    }

    public static Household from(String householdEncoded) {
        return new Household(householdEncoded);
    }

    private static int stringToInt(String bitString, int start, int end) {
        return Integer.valueOf(bitString.substring(start, end), 2);
    }

    private static long stringToLong(String bitString, int start, int end) {
        return Long.valueOf(bitString.substring(start, end), 2);
    }
    /*
    This is java implementation of household decoding.
    See original script at https://paste.yandex-team.ru/333079
    */
    private void extractValues(String householdEncoded) {
        String byteString = getBitString(Base64.getDecoder().decode(householdEncoded));

        this.hhid = stringToLong(byteString, 0, 32);
        this.version = stringToInt(byteString, 32, 34);
        this.male = stringToInt(byteString, 34, 35);
        this.female = stringToInt(byteString, 35, 36);
        this.child = stringToInt(byteString, 36, 37);
        this.grand = stringToInt(byteString, 37, 38);
        this.income = INCOMES.get(byteString.substring(38, 40));
        this.numberOfBrowsers = stringToInt(byteString, 40, 44);
        this.numberOfIndividualDevices = stringToInt(byteString, 44, 48);
        this.numberOfCollectiveDevices = stringToInt(byteString, 48, 52);
        this.numberOfStationaryDevices = stringToInt(byteString, 52, 56);
        this.numberOfUnstationaryDevices = stringToInt(byteString, 56, 60);
        this.platformsDesktopBrowser = stringToInt(byteString, 60, 61);
        this.platformsMobileApp = stringToInt(byteString, 61, 62);
        this.platformsMobileBrowser = stringToInt(byteString, 62, 63);
        this.platformsSmartTv = stringToInt(byteString, 63, 64);
        this.platformsOther = stringToInt(byteString, 64, 65);
        this.osWin = stringToInt(byteString, 65, 66);
        this.osIos = stringToInt(byteString, 66, 67);
        this.osAndroid = stringToInt(byteString, 67, 68);
        this.osMacos = stringToInt(byteString, 68, 69);
        this.osOther = stringToInt(byteString, 69, 70);

        extractLatLon(byteString);

        this.mainProfileMale = stringToInt(byteString, 122, 123);
        this.mainProfileFemale = stringToInt(byteString, 123, 124);
        this.mainProfileAge18 = stringToInt(byteString, 124, 125);
        this.mainProfileAge1824 = stringToInt(byteString, 125, 126);
        this.mainProfileAge2534 = stringToInt(byteString, 126, 127);
        this.mainProfileAge3544 = stringToInt(byteString, 127, 128);
        this.mainProfileAge4554 = stringToInt(byteString, 128, 129);
        this.mainProfileAge55 = stringToInt(byteString, 129, 130);

        int nAdhocs = stringToInt(byteString, 131, 143);
        int di = 155;
        this.adhocs = new ArrayList<>();
        for (int i = 0; i < nAdhocs; i++) {
            this.adhocs.add(stringToInt(byteString, di + i * 12, di + (i + 1) * 12));
        }

        int nThirdPartyData = stringToInt(byteString, 143, 155);
        di = 155 + nAdhocs * 12;
        this.thirdPartyData = new ArrayList<>();
        for (int i = 0; i < nThirdPartyData; i++) {
            this.thirdPartyData.add(stringToInt(byteString, di + i * 12, di + (i + 1) * 12));
        }
    }

    private void extractLatLon(String byteString) {
        if (stringToLong(byteString, 70, 122) != 0L) {
            float multiplier;
            if (byteString.substring(70, 71).equals("0")) {
                multiplier = 1f;
            } else {
                multiplier = -1f;
            }
            this.lat = (float) stringToLong(byteString, 71, 96)
                    / (1 << 17) * multiplier;

            if (byteString.substring(96, 97).equals("0")) {
                multiplier = 1f;
            } else {
                multiplier = -1f;
            }

            this.lon = (float) stringToLong(byteString, 97, 122)
                    / (1 << 17) * multiplier;
        }
    }

    private static String getBitString(byte[] bytes) {
        List<String> binaryStrings = new ArrayList<>();
        for (byte b : bytes) {
            String bits = Integer.toBinaryString(b);
            String bitsRepresentation;
            if (bits.length() >= 8) {
                bitsRepresentation = bits.substring(bits.length() - 8, bits.length());
            } else {
                int olderPartSize = 8 - bits.length();
                bitsRepresentation = String.join("", Collections.nCopies(olderPartSize, "0")) + bits;
            }
            binaryStrings.add(bitsRepresentation);
        }
        return String.join("", binaryStrings);
    }

    public long getHhid() {
        return hhid;
    }

    public int getVersion() {
        return version;
    }

    public int getMale() {
        return male;
    }

    public int getFemale() {
        return female;
    }

    public int getChild() {
        return child;
    }

    public int getGrand() {
        return grand;
    }

    public String getIncome() {
        return income;
    }

    public int getNumberOfBrowsers() {
        return numberOfBrowsers;
    }

    public int getNumberOfIndividualDevices() {
        return numberOfIndividualDevices;
    }

    public int getNumberOfCollectiveDevices() {
        return numberOfCollectiveDevices;
    }

    public int getNumberOfStationaryDevices() {
        return numberOfStationaryDevices;
    }

    public int getNumberOfUnstationaryDevices() {
        return numberOfUnstationaryDevices;
    }

    public int getPlatformsDesktopBrowser() {
        return platformsDesktopBrowser;
    }

    public int getPlatformsMobileApp() {
        return platformsMobileApp;
    }

    public int getPlatformsMobileBrowser() {
        return platformsMobileBrowser;
    }

    public int getPlatformsSmartTv() {
        return platformsSmartTv;
    }

    public int getPlatformsOther() {
        return platformsOther;
    }

    public int getOsWin() {
        return osWin;
    }

    public int getOsIos() {
        return osIos;
    }

    public int getOsAndroid() {
        return osAndroid;
    }

    public int getOsMacos() {
        return osMacos;
    }

    public int getOsOther() {
        return osOther;
    }

    public float getLat() {
        return lat;
    }

    public float getLon() {
        return lon;
    }

    public int getMainProfileMale() {
        return mainProfileMale;
    }

    public int getMainProfileFemale() {
        return mainProfileFemale;
    }

    public int getMainProfileAge18() {
        return mainProfileAge18;
    }

    public int getMainProfileAge1824() {
        return mainProfileAge1824;
    }

    public int getMainProfileAge2534() {
        return mainProfileAge2534;
    }

    public int getMainProfileAge3544() {
        return mainProfileAge3544;
    }

    public int getMainProfileAge4554() {
        return mainProfileAge4554;
    }

    public int getMainProfileAge55() {
        return mainProfileAge55;
    }

    public List<Integer> getAdhocs() {
        return adhocs;
    }

    public List<Integer> getThirdPartyData() {
        return thirdPartyData;
    }
}
