package ru.yandex.crypta.clients.blackbox;

public class AuthResult {

    public enum Method {
        SESSIONID,
        OAUTH
    }

    private final Method method;
    private final String login;
    private final String puid;
    private final boolean ok;
    private final boolean needReset;

    private AuthResult(Method method, String login, String puid, boolean ok, boolean needReset) {
        this.method = method;
        this.login = login;
        this.puid = puid;
        this.ok = ok;
        this.needReset = needReset;

    }

    public Method getMethod() {
        return method;
    }

    public String getLogin() {
        return login;
    }

    public String getPuid() {
        return puid;
    }

    public boolean isOk() {
        return ok;
    }

    public boolean needReset() {
        return needReset;
    }

    public static AuthResult ok(Method method, String login, String puid) {
        return new AuthResult(method, login, puid,true, false);
    }

    public static AuthResult fail(Method method) {
        return new AuthResult(method, null, null, false, false);
    }

    public static AuthResult needReset(Method method) {
        return new AuthResult(method, null, null, false, true);
    }

}
