package ru.yandex.crypta.clients.graphite;

public interface GraphiteClient {

    class GraphiteResponse {

        private final FullName name;
        private final Timestamp timestamp;
        private final Value value;

        public GraphiteResponse(FullName name, Timestamp timestamp, Value value) {
            this.name = name;
            this.timestamp = timestamp;
            this.value = value;
        }

        public FullName getName() {
            return name;
        }

        public Timestamp getTimestamp() {
            return timestamp;
        }

        public Value getValue() {
            return value;
        }

    }

    enum Frequency {
        ONE_SEC("one_sec"), FIVE_SEC("five_sec"), ONE_MIN("one_min"), FIVE_MIN("five_min"), ONE_HOUR("one_hour"),
        ONE_DAY("one_day");

        private final String alias;

        Frequency(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return alias;
        }
    }

    class FullName {

        private final Frequency frequency;
        private final String hostname;
        private final String group;
        private final String name;

        public FullName(Frequency frequency, String hostname, String group, String name) {
            this.frequency = frequency;
            this.hostname = hostname;
            this.group = group;
            this.name = name;
        }

        public Frequency getFrequency() {
            return frequency;
        }

        public String getHostname() {
            return hostname;
        }

        public String getGroup() {
            return group;
        }

        public String getName() {
            return name;
        }

    }

    class Timestamp {

        private final Long value;

        public Timestamp(Long value) {
            this.value = value;
        }

        public Long getValue() {
            return value;
        }

    }

    class Value {

        private final Double value;

        public Value(Double value) {
            this.value = value;
        }

        public Double getValue() {
            return value;
        }

    }

    GraphiteResponse report(FullName fullName, Timestamp timestamp, Value value);

}
