package ru.yandex.crypta.clients.pgaas;

import javax.inject.Inject;
import javax.sql.DataSource;

import com.zaxxer.hikari.HikariDataSource;
import org.jooq.Configuration;

import ru.yandex.crypta.lib.proto.TPostgresConfig;

public class HikariPostgresClient implements PostgresClient {

    private final DataSource dataSource;

    @Inject
    public HikariPostgresClient(TPostgresConfig config) {
        HikariDataSource hikari = new HikariDataSource();
        hikari.setJdbcUrl(config.getConnectionString());
        hikari.setUsername(config.getUsername());
        hikari.setPassword(config.getPassword());
        hikari.setMaximumPoolSize(config.getPoolSize());
        this.dataSource = hikari;
    }

    @Override
    public Configuration getJooqConfiguration() {
        return PostgresClient.wrap(dataSource);
    }

    @Override
    public DataSource getDataSource() {
        return dataSource;
    }

}
