package ru.yandex.crypta.clients.pgaas;

import java.sql.Connection;

import javax.sql.DataSource;

import org.jooq.Configuration;
import org.jooq.SQLDialect;
import org.jooq.conf.Settings;
import org.jooq.conf.StatementType;
import org.jooq.impl.DefaultConfiguration;

public interface PostgresClient {

    Configuration getJooqConfiguration();

    DataSource getDataSource();

    static Configuration settings() {
        Settings settings = new Settings();
        settings.setStatementType(StatementType.STATIC_STATEMENT);
        settings.setQueryTimeout(30);
        return new DefaultConfiguration()
                .set(SQLDialect.POSTGRES)
                .set(settings);
    }

    static Configuration wrap(DataSource dataSource) {
        return settings().set(dataSource);
    }

    static Configuration wrap(Connection connection) {
        return settings().set(connection);
    }

}
