package ru.yandex.crypta.clients.reactor;

import ru.yandex.crypta.clients.reactor.artifact.ArtifactCreateRequest;
import ru.yandex.crypta.clients.reactor.artifact.ArtifactInstantiationResponse;
import ru.yandex.crypta.clients.reactor.artifact.KeyValueAttributes;
import ru.yandex.crypta.clients.reactor.artifact.LastArtifactInstanceResponse;
import ru.yandex.crypta.clients.reactor.artifact.NamespaceIdentifier;


public interface ReactorClient {

    // creates new ArtifactInstance
    ArtifactInstantiationResponse ArtifactInstantiation(
            NamespaceIdentifier artifactIdentifier,
            String artifactType,
            String userTimestamp,
            KeyValueAttributes attributes,
            boolean createIfNotExist
    );

    // creates new ArtifactInstance and Artifact if needed
    ArtifactInstantiationResponse ArtifactInstanceCreate(
            NamespaceIdentifier artifactIdentifier,
            String artifactType,
            String userTimestamp,
            KeyValueAttributes attributes,
            boolean createIfNotExist,
            ArtifactCreateRequest artifactCreateRequest
    );

    // returns last ArtifactInstance
    LastArtifactInstanceResponse GetLastArtifactInstance(
            NamespaceIdentifier artifactIdentifier
    );
}
