package ru.yandex.crypta.clients.reactor.artifact;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class ArtifactCreateRequest {
    private final ObjectNode rootNode;

    public ArtifactCreateRequest(
        String typeKey,
        NamespaceIdentifier artifactIdentifier,
        NamespacePermissions permissions,
        boolean createParentNamespaces,
        boolean createIfNotExist,
        NamespaceIdentifier projectIdentifier
    ) {
        ObjectMapper mapper = new ObjectMapper();
        this.rootNode = mapper.createObjectNode();
        rootNode.putObject("artifactTypeIdentifier").put("artifactTypeKey", typeKey);
        rootNode.set("artifactIdentifier", artifactIdentifier.getRootNone());
        rootNode.set("permissions", permissions.getRootNone());
        rootNode.put("createParentNamespaces", createParentNamespaces);
        rootNode.put("createIfNotExist", createIfNotExist);
        rootNode.set("projectIdentifier", projectIdentifier.getRootNone());
    }

    public JsonNode getRootNone() {
        return rootNode;
    }
}
