package ru.yandex.crypta.clients.reactor.artifact;

import com.fasterxml.jackson.databind.JsonNode;


public class ArtifactInstantiationResponse {
    private final String artifactInstanceId;
    private final String creationTimestamp;
    private String artifactId = null;

    public ArtifactInstantiationResponse(JsonNode response) {
        this.artifactInstanceId = response.get("artifactInstanceId").textValue();
        this.creationTimestamp = response.get("creationTimestamp").textValue();

        if (response.has("artifactId")) {
            this.artifactId = response.get("artifactId").textValue();
        }
    }

    public String getArtifactInstanceId() {
        return this.artifactInstanceId;
    }

    public String getCreationTimestamp() {
        return creationTimestamp;
    }

    public String getArtifactId() {
        return artifactId;
    }
}
