package ru.yandex.crypta.clients.reactor.artifact;

import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class KeyValueAttributes {
    private ObjectNode attributes;
    private ObjectNode rootNode;

    public KeyValueAttributes() {
        ObjectMapper mapper = new ObjectMapper();
        this.rootNode = mapper.createObjectNode();
        this.attributes = rootNode.putObject("keyValue");
    }

    public void addArgument(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addArguments(Map<String, String> args) {
        for (Map.Entry<String, String> entry : args.entrySet()) {
            addArgument(entry.getKey(), entry.getValue());
        }
    }

    public JsonNode getRootNone() {
        return this.rootNode;
    }
}
