package ru.yandex.crypta.clients.reactor.artifact;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class NamespacePermissions {
    // permission levels
    public static final String RESPONSIBLE = "RESPONSIBLE"; // like admin
    public static final String WRITER = "WRITER";
    public static final String READER = "READER";
    public static final String BAN = "BAN";

    private final ObjectNode rootNode;
    private final ObjectNode roles;

    public NamespacePermissions(
        int version
    ) {
        ObjectMapper mapper = new ObjectMapper();
        this.rootNode = mapper.createObjectNode();
        this.roles = rootNode.putObject("roles");
        rootNode.put("version", version);
    }

    public void addRole(String name, String  permissionLevel) {
        this.roles.put(name, permissionLevel);
    }

    public JsonNode getRootNone() {
        return rootNode;
    }
}
