package ru.yandex.crypta.clients.redis;

import java.time.Duration;
import java.util.List;

public interface RedisClient {

    void set(Class<?> clazz, String entity, String field, String value);

    String get(Class<?> clazz, String entity, String field);

    void setBytes(Class<?> clazz, String entity, String field, byte[] value, Duration ttl);

    byte[] getBytes(Class<?> clazz, String entity, String field);

    List<String> listKeys(Class<?> clazz);

    long getLong(Class<?> clazz, String entity, String field);

    Long incr(Class<?> clazz, String entity, String field);

    Long decr(Class<?> clazz, String entity, String field);

    List<String> listKeys(Class<?> clazz, String entity);

    void addItem(Class<?> clazz, String entity, String field, byte[] item, int keepNItems);

    List<byte[]> getItems(Class<?> clazz, String entity, String field, int itemsCount);
}
