package ru.yandex.crypta.clients.sandbox.entity;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.misc.lang.DefaultObject;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class Context extends DefaultObject {

    private final Map<String, Object> value;

    @JsonCreator
    public Context(Map<String, Object> value) {
        this.value = value;
    }

    @JsonValue
    public Map<String, Object> getValue() {
        return value;
    }

}
