package ru.yandex.crypta.clients.sandbox.entity;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class Notification {

    private List<String> recipients = new ArrayList<>();
    private List<String> statuses = new ArrayList<>();
    private String transport;

    public Notification(String transport) {
        this.transport = transport;
    }

    public List<String> getRecipients() {
        return recipients;
    }

    public List<String> getStatuses() {
        return statuses;
    }

    public String getTransport() {
        return transport;
    }

    public Notification addRecipient(String recipient) {
        recipients.add(recipient);
        return this;
    }

    public Notification addStatus(String status) {
        statuses.add(status);
        return this;
    }

}
