package ru.yandex.crypta.clients.sandbox.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

import ru.yandex.misc.lang.DefaultObject;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(Include.NON_EMPTY)
public class Task extends DefaultObject {

    public static class Time {
        private String updated;
        private String created;

        public String getUpdated() {
            return updated;
        }

        public String getCreated() {
            return created;
        }
    }

    private Id id;
    private Type type;
    private Owner owner;
    private Status status;
    private Time time;

    public Task() {
    }

    public Id getId() {
        return id;
    }

    public Type getType() {
        return type;
    }

    public Owner getOwner() {
        return owner;
    }

    public Status getStatus() {
        return status;
    }

    public Time getTime() {
        return time;
    }
}
