package ru.yandex.crypta.clients.sandbox.entity;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(Include.NON_EMPTY)
public class TaskDraft extends DefaultObject {

    private Id id;
    private Type type;
    private Owner owner;
    private Priority priority;
    private Description description;
    private List<Notification> notifications = new ArrayList<>();
    private Long killTimeout;
    private List<CustomField> customFields = new ArrayList<>();
    private List<Tag> tags = new ArrayList<>();

    public TaskDraft() {
    }

    public Id getId() {
        return id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Owner getOwner() {
        return owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @JsonProperty("kill_timeout")
    public Long getKillTimeout() {
        return killTimeout;
    }

    public void setKillTimeout(Long killTimeout) {
        this.killTimeout = killTimeout;
    }

    public Priority getPriority() {
        return priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @JsonProperty("custom_fields")
    public List<CustomField> getCustomFields() {
        return customFields;
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    public TaskDraft addCustomField(CustomField customField) {
        customFields.add(customField);
        return this;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Description getDescription() {
        return description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public List<Notification> getNotifications() {
        return notifications;
    }

    public TaskDraft addTag(Tag tag) {
        tags.add(tag);
        return this;
    }

    public TaskDraft addNotification(Notification notification) {
        notifications.add(notification);
        return this;
    }
}
