package ru.yandex.crypta.clients.startrek;

import java.util.concurrent.TimeUnit;

import javax.inject.Inject;

import ru.yandex.crypta.lib.proto.TStartrekConfig;
import ru.yandex.startrek.client.Session;
import ru.yandex.startrek.client.StartrekClientBuilder;
import ru.yandex.startrek.client.error.EntityNotFoundException;
import ru.yandex.startrek.client.model.Issue;
import ru.yandex.startrek.client.model.IssueCreate;

public class DefaultStartrekClient implements CryptaStartrekClient {
    private final Session startrek;

    @Inject
    public DefaultStartrekClient(TStartrekConfig config) {
        this.startrek = StartrekClientBuilder.newBuilder()
                .uri(config.getUrl())
                .maxConnections(10)
                .connectionTimeout(1, TimeUnit.SECONDS)
                .socketTimeout(1000, TimeUnit.MILLISECONDS)
                .build(config.getToken());
    }

    @Override
    public Issue createIssue(IssueCreate create) {
        return startrek.issues().create(create);
    }

    @Override
    public Issue getIssueById(String issueId) {
        try {
            return startrek.issues().get(issueId);
        } catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public Session get() {
        return startrek;
    }
}
