package ru.yandex.crypta.clients.step;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.crypta.clients.step.entity.StepEvent;
import ru.yandex.crypta.clients.step.entity.StepEventDescription;

public interface StepEventClient {

    void registerEventDescription(StepEventDescription eventType);

    void updateEventDescription(StepEventDescription eventType);

    Optional<JsonNode> getEventDescription(String eventType);

    void deleteEventDescription(String eventType);

    String createEvent(StepEvent event);

    Optional<JsonNode> getEventInfo(String eventId);

    List<JsonNode> searchEventInfo(String eventType, Map<String, String> params, Integer limit);
}
