package ru.yandex.crypta.clients.step.entity;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(Include.NON_EMPTY)
public class StepEventDescription extends DefaultToString {
    private String name;
    private String description;
    private List<String> requiredFields;
    private List<String> optionalFields;
    private boolean listInIdm = false;
    private boolean makePublic = false;

    public StepEventDescription(String name, String description, List<String> requiredFields, List<String> optionalFields) {
        this.name = name;
        this.description = description;
        this.requiredFields = requiredFields;
        this.optionalFields = optionalFields;
    }

    public StepEventDescription(String name, String description, List<String> requiredFields, List<String> optionalFields, boolean listInIdm, boolean makePublic) {
        this.name = name;
        this.description = description;
        this.requiredFields = requiredFields;
        this.optionalFields = optionalFields;
        this.listInIdm = listInIdm;
        this.makePublic = makePublic;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    @JsonProperty("required_fields")
    public List<String> getRequiredFields() {
        return requiredFields;
    }

    @JsonProperty("optional_fields")
    public List<String> getOptionalFields() {
        return optionalFields;
    }

    @JsonProperty("list_in_idm")
    public boolean isListInIdm() {
        return listInIdm;
    }

    @JsonProperty("public")
    public boolean isMakePublic() {
        return makePublic;
    }
}
