package ru.yandex.crypta.clients.tvm;

import java.util.List;
import java.util.Optional;

import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.passport.tvmauth.CheckedServiceTicket;

public class AudienceTvmClientImpl implements TvmClient {
    private final Tvm2 tvm;

    public AudienceTvmClientImpl(Tvm2 tvm) {
        this.tvm = tvm;
        this.tvm.start();
    }

    @Override
    public Optional<String> getServiceTicket(int dstTvmId) {
        return tvm.getServiceTicket(dstTvmId).toOptional();
    }

    @Override
    public void setDstClientIds(List<Integer> dstClientIds) {
        this.tvm.addDstClientIds(dstClientIds);
    }

    @Override
    public CheckedServiceTicket checkServiceTicket(String serviceTicketBody) {
        return tvm.checkServiceTicket(serviceTicketBody);
    }
}
