package ru.yandex.crypta.clients.tvm;

import javax.inject.Inject;

import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.lib.proto.TTvmConfig;
import ru.yandex.passport.tvmauth.ClientStatus;
import ru.yandex.passport.tvmauth.NativeTvmClient;
import ru.yandex.passport.tvmauth.TvmApiSettings;
import ru.yandex.passport.tvmauth.TvmClient;

public class DefaultTvmClient implements IDefaultTvmClient {
    private final TvmClient tvm;

    @Inject
    public DefaultTvmClient(TTvmConfig config) {
        var settings = new TvmApiSettings()
                .setSelfTvmId(config.getSourceTvmId())
                .enableServiceTicketChecking();

        // localhost:<port> used in CI tests instead of tvm-api.yandex.net
        if (config.hasLocalhostPort()) {
            settings.setTvmPortForLocalhost(config.getLocalhostPort());
        } else {
            throw Exceptions.internal("Failed to set local TVM port");
        }

        this.tvm = NativeTvmClient.create(settings);
    }

    @Override
    public ClientStatus getStatus() {
        return tvm.getStatus();
    }

    public TvmClient get() {
        return tvm;
    }
}
