package ru.yandex.crypta.clients.tvm;

import java.util.List;
import java.util.Optional;

import org.joda.time.Duration;

import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.Tvm2ApiClient;
import ru.yandex.inside.passport.tvm2.TvmClientCredentials;
import ru.yandex.passport.tvmauth.CheckedServiceTicket;


public interface TvmClient {
    Optional<String> getServiceTicket(int dstTvmId);

    void setDstClientIds(List<Integer> dstClientIds);

    CheckedServiceTicket checkServiceTicket(String serviceTicket);

    static Tvm2 createTvm2(int tvmId, String secret, int localHostPort) {
        TvmClientCredentials credentials = new TvmClientCredentials(tvmId, secret);

        Tvm2 tvm;
        if (localHostPort != 0) {
            String tvmApiUrl = String.format("http://localhost:%d", localHostPort);
            Tvm2ApiClient apiClient = new Tvm2ApiClient(tvmApiUrl);
            tvm = new Tvm2(apiClient, credentials, Duration.standardHours(1), Duration.standardSeconds(1));
        } else {
            tvm = new Tvm2(credentials);
        }

        return tvm;
    }
}
