package ru.yandex.crypta.clients.tvm;

import java.util.List;
import java.util.Optional;

import javax.inject.Inject;

import ru.yandex.crypta.lib.proto.TTvmConfig;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.passport.tvmauth.CheckedServiceTicket;

public class TvmClientIcebergImpl implements TvmClient {

    private final Tvm2 tvm;

    @Inject
    public TvmClientIcebergImpl(TTvmConfig config) {
        this.tvm = TvmClient.createTvm2(config.getSourceTvmId(), config.getSecret(), config.getLocalhostPort());
        this.tvm.start();
    }

    @Override
    public Optional<String> getServiceTicket(int dstTvmId) {
        return tvm.getServiceTicket(dstTvmId).toOptional();
    }

    @Override
    public void setDstClientIds(List<Integer> dstClientIds) {
        this.tvm.addDstClientIds(dstClientIds);
    }

    @Override
    public CheckedServiceTicket checkServiceTicket(String serviceTicketBody) {
        return tvm.checkServiceTicket(serviceTicketBody);
    }
}
