package ru.yandex.crypta.clients.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;

public class Caching {

    private Caching() {

    }

    public static <K,V> V fetch(Cache<K, V> cache, K key, Callable<V> missingSupplier) {
        try {
            return cache.get(key, missingSupplier);
        } catch (ExecutionException | UncheckedExecutionException e) {
            throw (RuntimeException) e.getCause();
        }
    }

    public static <K,V> V fetchLoading(LoadingCache<K, V> cache, K key) {
        try {
            return cache.get(key);
        } catch (ExecutionException | UncheckedExecutionException e) {
            throw (RuntimeException) e.getCause();
        }
    }

}
