package ru.yandex.crypta.clients.utils;

import java.io.IOException;

import okhttp3.Response;

import ru.yandex.crypta.common.exception.Exceptions;

public class HttpExceptions {
    public static void checkResponse(Response response) throws IOException {
        if (response.code() == OkHttpUtils.FORBIDDEN_STATUS) {
            throw Exceptions.notAuthenticated("Not authenticated");
        }

        if (response.code() == OkHttpUtils.NOT_FOUND) {
            throw Exceptions.notFound();
        }

        if (response.code() > 404 && response.code() < 500) {
            throw Exceptions.wrongRequestException("Wrong request", String.valueOf(response.code()));
        }

        if (response.code() != OkHttpUtils.OK_STATUS) {
            throw Exceptions.internal(
                    String.format("%d %s: %s", response.code(), response.message(), response.body().string())
            );
        }
    }
}
