package ru.yandex.crypta.clients.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.function.Function;

public class JsonUtils {
    public static Stream<JsonNode> jsonArrayToStream(JsonNode node) {
        return StreamSupport.stream(node.spliterator(), false);
    }

    public static <T> Map<String, T> jsonToMap(JsonNode node, Function<JsonNode, T> valueMapper) {
        Map<String, T> result = new HashMap<>();
        Iterator<Entry<String, JsonNode>> fields = node.fields();
        while (fields.hasNext()) {
            Entry<String, JsonNode> entry = fields.next();
            result.put(entry.getKey(), valueMapper.apply(entry.getValue()));
        }
        return result;
    }

}
