package ru.yandex.crypta.clients.utils;

import java.io.IOException;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class OkHttpUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static final int OK_STATUS = 200;
    public static final int NOT_FOUND = 404;
    public static final int FORBIDDEN_STATUS = 403;

    public static OkHttpClient getUnsafeOkHttpClient() {
        try {
            // Create a trust manager that does not validate certificate chains
            final TrustManager[] trustAllCerts = new TrustManager[]{
                    new X509TrustManager() {
                        @Override
                        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                            return new java.security.cert.X509Certificate[]{};
                        }
                    }
            };

            // Install the all-trusting trust manager
            final SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new java.security.SecureRandom());
            // Create an ssl socket factory with our all-trusting manager
            final SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager) trustAllCerts[0]);
            builder.hostnameVerifier((hostname, session) -> true);

            return builder.build();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode getResponseJson(Response response) {
        String responseBody = null;

        try {
            responseBody = response.body().string();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read response body", e);
        }

        try{
            return OBJECT_MAPPER.readValue(responseBody, JsonNode.class);
        } catch (IOException e) {
            throw new RuntimeException("Malformed response: " + responseBody, e);
        }
    }


    public static <Proto extends Message> Proto getResponseProto(Response response, Parser<Proto> parser) {
        try {
            var responseBody = response.body().bytes();
            return parser.parseFrom(responseBody);
        } catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Malformed proto response: ", e);
        } catch (IOException e) {
            throw new RuntimeException("Failed to read response body", e);
        }
    }
}
