package ru.yandex.crypta.clients.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import okhttp3.Dns;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;

public class OnlyInet6AddressDns implements Dns {

    @Override
    public List<InetAddress> lookup(String host) throws UnknownHostException {
        InetAddress[] allAddresses = SystemDefaultDnsResolver.INSTANCE.resolve(host);
        List<InetAddress> matchedAddresses = Arrays.stream(allAddresses)
                .filter(address -> address instanceof Inet6Address)
                .collect(Collectors.toList());
        if (matchedAddresses.isEmpty()) {
            throw new UnknownHostException("No IPv6 address");
        } else {
            return matchedAddresses;
        }
    }
}
