package ru.yandex.crypta.clients.yabs;

import java.io.IOException;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringEscapeUtils;


class AdParser {
    private static ScriptEngine getEngine() {
        ScriptEngineManager factory = new ScriptEngineManager();
        return factory.getEngineByName("nashorn");
    }

    static JsonNode parse(String malformedJs) throws ScriptException, IOException {
        String[] parts = malformedJs.split("]\\(\'", 2);

        if (parts.length < 2) {
            throw new IllegalArgumentException();
        }

        String preSplit = parts[1];
        String mainPart = preSplit.substring(0, preSplit.length() - 2);

        ScriptEngine engine = getEngine();
        engine.eval("var a = JSON.stringify(" + mainPart + ");");
        String jsonString = engine.get("a").toString();

        return new ObjectMapper().readTree(jsonString);
    }

    static String cleanHtmlText(String rawTitle) {
        String title = rawTitle.replaceAll("<[^>]*>", "");
        return StringEscapeUtils.unescapeHtml4(title);
    }

}
