package ru.yandex.crypta.clients.yabs;

import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;

public interface YabsClient {

    JsonNode getAd(String pageId, Map<String, String> queryString, String userId, String userAgent,
                   String yabsExpSid, DebugMode debugMode, String ip);

    JsonNode getAdJson(String pageId, Map<String, String> queryString, String yandexuid, String userAgent,
                       String yabsExpSid, DebugMode debugMode, String ip);

    JsonNode getAdDebug(String pageId, Map<String, String> queryString, String userId, String userAgent,
                        String yabsExpSid, String ip);

    JsonNode updateDebugCookie();

    enum DebugMode {SIMPLE, ADVANCED, MX}

    enum YabsOutputFormat {
        JSON("json"),
        PROTO_TEXT("proto-text");

        final String value;

        YabsOutputFormat(String value) {
            this.value = value;
        }
    }
}
