package ru.yandex.crypta.config;

import java.util.Comparator;

import io.swagger.models.Contact;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;

import ru.yandex.crypta.common.ws.jersey.exception.mapper.ErrorMessage;
import ru.yandex.crypta.common.ws.swagger.SwaggerUtils;
import ru.yandex.library.svnversion.VcsVersion;

public class ApiSwagger {
    private static final String WIKI_URL = "https://wiki.yandex-team.ru/crypta/";

    private ApiSwagger() {
    }

    public static Swagger process(Class<?> clazz, String title, String description, Swagger swagger) {
        VcsVersion vcsVersion = new VcsVersion(clazz);
        String apiVersion = String.valueOf(vcsVersion.getProgramSvnRevision());

        SwaggerUtils.fillDefaultOperationResponses(swagger, ErrorMessage.class, SwaggerUtils.BASIC_HTTP_ERRORS);
        SwaggerUtils.setupProperFileResponseSchema(swagger);
        SwaggerUtils.makeJsonNodeArbitrary(swagger);
        swagger.getTags().sort(Comparator.comparing(Tag::getName));
        Contact contact = new Contact().url(WIKI_URL);
        swagger.getInfo().version(apiVersion).title(title).description(description).contact(contact);
        return swagger;
    }

}
