package ru.yandex.crypta.config;

import ru.yandex.crypta.common.ws.logging.Hacks;

public class Initialization {

    private Initialization() {
    }

    public static void run(Class<?> clazz) {
        initializeMainThread(clazz);
        Hacks.disableAccessWarnings();
        Hacks.logUncaughtExceptions();
        Hacks.redirectJulToSlf4j();
        setupLoggingProperties();
    }

    private static void initializeMainThread(Class<?> clazz) {
        Thread.currentThread().setName(clazz.getCanonicalName());
    }

    private static void setupLoggingProperties() {
        System.setProperty("org.jboss.logging.provider", "slf4j");
        System.setProperty("org.freemarker.loggerLibrary", "SLF4J");
    }

}
