#include "ru_yandex_crypta_lib_entity_counters_EntityCounters.h"

#include <ads/bsyeti/libs/counter/counter_storage.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

namespace {
    void rethrow_as_java(JNIEnv* env) {
        try {
            throw;
        } catch (const std::exception& e) {
            jclass jc = env->FindClass("java/lang/RuntimeException");
            if (jc) {
                env->ThrowNew(jc, e.what());
            }
        } catch (...) {
            jclass jc = env->FindClass("java/lang/RuntimeException");
            if (jc) {
                env->ThrowNew(jc, "Unhandled exception");
            }
        }
    }
}

JNIEXPORT jobject JNICALL Java_ru_yandex_crypta_lib_entity_counters_EntityCounters_getCounters(JNIEnv* env, jclass)
{
    try {
        auto hashMapClass = env->FindClass("java/util/HashMap");
        auto hashMapInit = env->GetMethodID(hashMapClass, "<init>", "()V");
        auto hashMap = env->NewObject(hashMapClass, hashMapInit);
        auto put = env->GetMethodID(hashMapClass, "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");

        auto counterClassInfo = env->FindClass("ru/yandex/crypta/lib/entity/counters/EntityCounters$CounterInfo");
        auto counterClassInfoInit = env->GetMethodID(counterClassInfo, "<init>", "(IILjava/lang/String;Ljava/lang/String;)V");

        auto integer = env->FindClass("java/lang/Integer");
        auto integerInit = env->GetMethodID(integer, "<init>", "(I)V");

        const auto* counterIdDesc = NBSYeti::NCounter::ECounterId_descriptor();

        for (const auto& [counterId, source, fieldName]: NBSYeti::ENTITY_COUNTERS) {
            auto type = env->NewStringUTF(fieldName.substr(16).c_str());
            auto jCounterId = env->NewObject(integer, integerInit, counterId);

            const auto& counterDescription = counterIdDesc->FindValueByNumber(counterId)->options().GetExtension(NBSYeti::NCounter::CounterDescription);
            const auto& ageCounterId = counterDescription.GetTimeCounterId();
            auto jAgeCounterId = env->NewObject(integer, integerInit, ageCounterId);

            auto description = env->NewStringUTF(counterDescription.GetDescription().c_str());

            auto counter = env->NewObject(
                counterClassInfo,
                counterClassInfoInit,
                counterId,
                ageCounterId,
                type,
                description
            );

            env->CallObjectMethod(hashMap, put, jCounterId, counter);
            env->CallObjectMethod(hashMap, put, jAgeCounterId, counter);

            env->DeleteLocalRef(jCounterId);
            env->DeleteLocalRef(jAgeCounterId);
            env->DeleteLocalRef(counter);
            env->DeleteLocalRef(type);
            env->DeleteLocalRef(description);
        }

        auto hashMapGlobal = static_cast<jobject>(env->NewGlobalRef(hashMap));
        return hashMapGlobal;
    } catch(...) {
        rethrow_as_java(env);
        return nullptr;
    }
}
