package ru.yandex.crypta.lib.entity.counters;

import java.util.Map;
import java.util.Set;


public final class EntityCounters {
    static {
        System.loadLibrary("entity-counters-jni");
    }

    public static class CounterInfo {
        public final int valueCounterId;
        public final int ageCounterId;
        public final String type;
        public final String description;

        public CounterInfo(int valueCounterId, int ageCounterId, String type, String description) {
            this.valueCounterId = valueCounterId;
            this.ageCounterId = ageCounterId;
            this.type = type;
            this.description = description;
        }
    }

    private static native Map<Integer, CounterInfo> getCounters();

    private static final Map<Integer, CounterInfo> COUNTER_MAP = getCounters();

    public static Set<Integer> getAllCounterIds() {
        return COUNTER_MAP.keySet();
    };

    public static CounterInfo getCounterInfo(int counterId) {
        return COUNTER_MAP.get(counterId);
    };
}
