package ru.yandex.crypta.lib.schedulers;

import java.util.Date;

import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class TriggerView {

    private final Trigger trigger;

    public TriggerView(Trigger trigger) {
        this.trigger = trigger;
    }

    public TriggerKey getKey() {
        return trigger.getKey();
    }

    public JobKey getJobKey() {
        return trigger.getJobKey();
    }

    public Date getNextFireTime() {
        return trigger.getNextFireTime();
    }

    public Date getPreviousFireTime() {
        return trigger.getPreviousFireTime();
    }

    public Date getFinalFireTime() {
        return trigger.getFinalFireTime();
    }

    public String getDescription() {
        return trigger.getDescription();
    }

}
