package ru.yandex.crypta.service.bigrt;

import java.nio.ByteBuffer;

import com.github.luben.zstd.Zstd;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;

public class BigRTHelper {

    private ByteBuffer decompress(byte[] src) {

        ByteBuffer inputBuffer = ByteBuffer.allocateDirect(src.length);
        inputBuffer.put(src);
        inputBuffer.flip();

        // input contains original data size + compressed bytes
        long outputSizeUnsigned = Long.reverseBytes(inputBuffer.getLong());
        // can't really address negative values
        int outputSize = (int) (outputSizeUnsigned & 0xffffffffL);

        ByteBuffer outputBuffer = ByteBuffer.allocateDirect(outputSize);
        Zstd.decompress(outputBuffer, inputBuffer);
        outputBuffer.flip();

        return outputBuffer;

    }


    public <T extends GeneratedMessageV3> T parseState(byte[] stateData, Parser<T> parser) {
        ByteBuffer protoBytes;
        try {
            protoBytes = decompress(stateData);
        } catch (Exception e) {
            throw new IllegalStateException("Can't decompress BigRT state", e);
        }

        try {
            return parser.parseFrom(protoBytes);
        } catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Can't parse BigRT state", e);
        }

    }
}
