package ru.yandex.crypta.service.bmcategory;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import javax.inject.Inject;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class DefaultBMCategoryService implements BMCategoryService {
    private static final String BM_CATEGORY_TABLE = "//home/yabs/dict/BMCategory";
    private static final String FIELD_BM_CATEGORY_ID = "BMCategoryID";
    private static final String FIELD_DESCRIPTION = "Description";

    private final YtService ytService;

    private ExecutorService parentExecutor = Executors.newSingleThreadExecutor();
    private final ListeningExecutorService executorService = MoreExecutors.listeningDecorator(parentExecutor);

    private LoadingCache<Integer, Map<Long, String>> cache = CacheBuilder.newBuilder()
            .refreshAfterWrite(1, TimeUnit.DAYS)
            .build(
                    new CacheLoader<Integer, Map<Long, String>>() {
                        @Override
                        public Map<Long, String> load(Integer key) {
                            return getBMCategories();
                        }

                        @Override
                        public ListenableFuture<Map<Long, String>> reload(final Integer key,
                                Map<Long, String> oldValue)
                        {
                            // Load new values asynchronously and non-blocking
                            return executorService.submit(() -> load(0));
                        }
                    }
            );

    @Inject
    public DefaultBMCategoryService(
            YtService ytService
    )
    {
        this.ytService = ytService;
    }

    @Override
    public Map<Long, String> getBMCategories() {
        ListF<YTreeMapNode> rows = Cf.arrayList();
        ytService.getHahn().tables().selectRows(
                String.format(
                        "%1$s, %2$s FROM [%3$s]",
                        FIELD_BM_CATEGORY_ID, FIELD_DESCRIPTION, BM_CATEGORY_TABLE
                ),
                YTableEntryTypes.YSON,
                (Consumer<YTreeMapNode>) rows::add);

        return rows.stream().collect(Collectors.toMap(
                item -> item.getLong(FIELD_BM_CATEGORY_ID),
                item -> item.getString(FIELD_DESCRIPTION)
        ));
    }

    @Override
    public LoadingCache<Integer, Map<Long, String>> getCache() {
        return cache;
    }

    @Override
    public void refreshCache() {
        cache.refresh(0);
    }

}
