package ru.yandex.crypta.service.domains;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import javax.inject.Inject;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.clients.utils.Caching;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


public class TargetDomainService implements DomainService {
    private final static String TARGET_DOMAIN_TABLE = "//home/yabs/dict/TargetDomain";
    private final static String FIELD_DOMAIN_ID = "DomainID";
    private final static String FIELD_DOMAIN = "Domain";

    private final YtService ytService;

    private Cache<String, Map<Integer, String>> cache = CacheBuilder.newBuilder()
            .expireAfterWrite(10, TimeUnit.MINUTES)
            .build();

    @Inject
    public TargetDomainService(YtService ytService) {
        this.ytService = ytService;
    }

    @Override
    public Map<Integer, String> getDomainsByIds(List<Integer> ids) {
        ListF<YTreeMapNode> rows = Cf.arrayList();

        ytService.getHahn().tables().selectRows(String.format(
                "%1$s, %2$s FROM [%3$s] WHERE %5$s in (%4$s)",
                FIELD_DOMAIN_ID, FIELD_DOMAIN, TARGET_DOMAIN_TABLE,
                String.join(",", ids.stream().map(String::valueOf).collect(Collectors.toList())),
                FIELD_DOMAIN_ID
                ),
                YTableEntryTypes.YSON,
                (Consumer<YTreeMapNode>) rows::add);

        return rows.stream().collect(Collectors.toMap(
                item -> item.getInt(FIELD_DOMAIN_ID),
                item -> item.getString(FIELD_DOMAIN)
        ));
    }

    @Override
    public Map<Integer, String> fetchUserDomainsByIds(String yandexuid, List<Integer> ids) {
        return Caching.fetch(cache, yandexuid,
                () -> getDomainsByIds(ids));
    }
}
