package ru.yandex.crypta.service.experiments;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.inject.Inject;

import NBSYeti.NExperimentParameters.Experiment;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.MessageOrBuilder;

import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.utils.Caching;
import ru.yandex.crypta.lib.experiments.Experiments;

public class DefaultExperimentsService implements ExperimentsService {

    private static final String BS_YETI_LIGHT_CONFIGS = "BS_YETI_LIGHT_CONFIGS";
    // TODO replace with config
    private static final String BIGB_AB_EXPERIMENTS_PRODUCTION_CONFIG = "BIGB_AB_EXPERIMENTS_PRODUCTION_CONFIG";
    private static final String SELECT_TYPE_JSON = "select_type.json";

    private final SandboxClient sandboxClient;
    private final Cache<Integer, Experiments> cache = CacheBuilder
            .newBuilder()
            .expireAfterWrite(10, TimeUnit.MINUTES)
            .build();

    @Inject
    public DefaultExperimentsService(SandboxClient sandboxClient) {
        this.sandboxClient = sandboxClient;
    }

    private final Experiments experiments() {
        return Caching.fetch(cache, 0, () -> {
            var bsYetiConfig = sandboxClient.getLatest(BS_YETI_LIGHT_CONFIGS, SELECT_TYPE_JSON);
            var abConfig = sandboxClient.getLatest(BIGB_AB_EXPERIMENTS_PRODUCTION_CONFIG);
            return new Experiments(bsYetiConfig, abConfig);
        });
    }

    @Override
    public Experiment.TExperimentParameters getExperimentParameters(long uniqId, long timestamp) {
        return experiments().getExperimentParameters(uniqId, timestamp);
    }

    @Override
    public List<NExperiments.Experiment.TExperiment> getActiveExperiments(long uniqid, long timestamp) {
        return experiments().getActiveExperiments(uniqid, timestamp);
    }

    private static void flatten(List<ExperimentParameter> paths, String path, Object object) {
        if (object instanceof MessageOrBuilder) {
            MessageOrBuilder message = (MessageOrBuilder) object;
            for (FieldDescriptor field : message.getDescriptorForType().getFields()) {
                if (field.isRepeated()) {
                    List<?> valueList = (List<?>) message.getField(field);

                    int index = 0;
                    for (Object subValue : valueList) {
                        flatten(paths, String.join(".", path, String.valueOf(index++)), subValue);
                    }
                } else {
                    flatten(paths, String.join(".", path, field.getName()), message.getField(field));
                }
            }
        } else {
            paths.add(new ExperimentParameter(path, String.valueOf(object)));
        }
    }

    private List<ExperimentParameter> flattenExperiments(Experiment.TExperimentParameters parameters) {
        List<ExperimentParameter> paths = new ArrayList<>();

        for (FieldDescriptor field : parameters.getDescriptorForType().getFields()) {
            flatten(paths, field.getName(), parameters.getField(field));
        }

        return paths;
    }

    @Override
    public List<ExperimentParameter> getExperimentParametersFlatten(long uniqId, long timestamp) {
        Experiment.TExperimentParameters parameters = experiments().getExperimentParameters(uniqId, timestamp);
        return flattenExperiments(parameters);
    }
}
