package ru.yandex.crypta.service.me.keyword;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;

public class GeoKeyword extends Keyword {

    public final static String REGULAR_GEO_ID = "371";
    public final static String ACTUAL_GEO_ID = "291";

    private GeoKeyword(Consumer<JsonNode> setter) {
        super(setter);
    }

    public static GeoKeyword with(Consumer<JsonNode> setter) {
        return new GeoKeyword(setter);
    }

    public static ArrayNode getRegular(JsonNode jsonNode) {
        return (ArrayNode) jsonNode.findPath("data");
    }

    public static List<Long> getActual(JsonNode jsonNode) {
        return List.of(getValue(jsonNode).split(":")).stream().map(Long::valueOf).collect(Collectors.toList());
    }

    public static long getTimestamp(JsonNode jsonNode) {
        return jsonNode.findPath("time").asLong();
    }

}
