package ru.yandex.crypta.service.me.keyword;

import java.util.function.Consumer;

import com.fasterxml.jackson.databind.JsonNode;

public abstract class Keyword {

    private static final Float MAX_VALUE = 1000000.0f;

    private final Consumer<JsonNode> setter;

    protected Keyword(Consumer<JsonNode> setter) {
        this.setter = setter;
    }

    public static long getTimestamp(JsonNode jsonNode) {
        return jsonNode.findPath("time").asLong(0);
    }

    public static String getValue(JsonNode jsonNode) {
        return jsonNode.findPath("value").asText();
    }

    public static float getWeight(JsonNode jsonNode) {
        return normalize(Float.valueOf(jsonNode.findPath("weight").asText("0")));
    }

    public static float normalize(float raw) {
        return raw / MAX_VALUE;
    }

    public static String beforeSemicolon(String raw) {
        return raw.split(":", -1)[0];
    }

    public void accept(JsonNode jsonNode) {
        setter.accept(jsonNode);
    }

}
