package ru.yandex.crypta.service.me.keyword;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.misc.lang.Check;

public class WeightedKeyword extends Keyword {

    private final Map<String, Consumer<Float>> valueToWeightSetter;
    private final Consumer<Long> timestampSetter;

    private WeightedKeyword(Map<String, Consumer<Float>> valueToWeightSetter, Consumer<Long> timestampSetter) {
        super(null);
        this.valueToWeightSetter = valueToWeightSetter;
        this.timestampSetter = timestampSetter;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void accept(JsonNode jsonNode) {
        String value = Keyword.getValue(jsonNode);
        float weight = Keyword.getWeight(jsonNode);
        long timestamp = Keyword.getTimestamp(jsonNode);
        valueToWeightSetter.get(value).accept(weight);
        timestampSetter.accept(timestamp);
    }

    public static class Builder {

        private Map<String, Consumer<Float>> valueToWeightSetter = new HashMap<>();
        private Consumer<Long> timestampSetter = null;

        public Builder value(String value, Consumer<Float> weightSetter) {
            Check.notIn(value, valueToWeightSetter.keySet());
            valueToWeightSetter.put(value, weightSetter);
            return this;
        }

        public Builder timestamp(Consumer<Long> timestampSetter) {
            Check.notNull(timestampSetter);
            this.timestampSetter = timestampSetter;
            return this;
        }

        public WeightedKeyword build() {
            Check.notEmpty(valueToWeightSetter.keySet());
            Check.notNull(timestampSetter);
            return new WeightedKeyword(valueToWeightSetter, timestampSetter);
        }

    }
}
