package ru.yandex.crypta.service.task;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import ru.yandex.crypta.lib.proto.EEnvironment;
import ru.yandex.inside.juggler2.JugglerAsyncClient;
import ru.yandex.inside.juggler2.Status;
import ru.yandex.inside.juggler2.event.JugglerEvent;

public class JugglerTaskStatusReporter implements TaskStatusReporter {

    private final JugglerAsyncClient jugglerClient;

    @Inject
    public JugglerTaskStatusReporter(EEnvironment env) {
        this.jugglerClient = new JugglerAsyncClient(EEnvironment.ENV_PRODUCTION == env);
    }

    @Override
    public void reportTaskStatus(String taskType, String taskStatus, String environment,
            Map<String, String> taskParameters)
    {
        Status jugglerStatus = TaskStatus.SUCCESS.equals(taskStatus) ? Status.OK : Status.WARN;

        String host = "stable".equals(environment) ? "crypta-task-status" : "crypta-task-status-testing";
        ZoneOffset almostMoscowZone = ZoneOffset.ofHours(3);
        JugglerEvent jugglerEvent = new JugglerEvent(
                taskType + ": " + LocalDateTime.now(almostMoscowZone),
                host,
                "",
                taskType,
                jugglerStatus,
                List.of("crypta", environment)
        );
        jugglerClient.addEventBatch(List.of(jugglerEvent)).join();
    }
}
