package ru.yandex.crypta.service.task;

import java.util.List;
import java.util.Map;

import ru.yandex.crypta.service.task.model.CryptaTaskStatusChangeInfo;
import ru.yandex.crypta.service.task.model.CryptaTaskStatusChangedEvent;

public interface TaskStatusService {
    void reportNewTaskStatus(CryptaTaskStatusChangedEvent changedEvent);

    void reportExistingTaskStatus(String taskInstanceId, String taskType, String taskStatus,
            String environment,
            Map<String, String> taskParameters);

    List<CryptaTaskStatusChangeInfo> getTaskInstanceHistory(String taskInstanceId, String taskType,
            String environment,
            Map<String, String> taskParameters);

    List<CryptaTaskStatusChangeInfo> getTaskTypeHistory(String taskType,
            String environment,
            Map<String, String> taskParameters);
}
