package ru.yandex.crypta.service.task.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.misc.lang.DefaultObject;

public class CryptaTaskStatusChangedEvent extends DefaultObject {

    public static final String TASK_INSTANCE_ID_FIELD = "taskInstanceId";
    public static final String TASK_TYPE_FIELD = "taskType";
    public static final String TASK_STATUS_FIELD = "taskStatus";
    public static final String ENVIRONMENT_FIELD = "environment";
    public static final List<String> PREDEFINED_FIELDS = Arrays.asList(
            TASK_INSTANCE_ID_FIELD,
            TASK_TYPE_FIELD,
            TASK_STATUS_FIELD,
            ENVIRONMENT_FIELD
    );

    private String taskInstanceId;
    private String taskType;
    private String taskStatus;
    private String environment;
    private Map<String, String> taskParameters;

    public CryptaTaskStatusChangedEvent(String taskType, String taskStatus,
            String environment, Map<String, String> taskParameters)
    {
        this(GUID.create().toString(), taskType, taskStatus, environment, taskParameters);
    }

    public CryptaTaskStatusChangedEvent(String existingInstanceId, String taskType, String taskStatus,
            String environment, Map<String, String> taskParameters)
    {
        this.taskInstanceId = existingInstanceId;
        this.taskType = taskType;
        this.taskStatus = taskStatus;
        this.environment = environment;
        this.taskParameters = taskParameters;
    }

    public String getTaskInstanceId() {
        return taskInstanceId;
    }

    public String getTaskType() {
        return taskType;
    }

    public String getTaskStatus() {
        return taskStatus;
    }

    public String getEnvironment() {
        return environment;
    }

    public Map<String, String> getTaskParameters() {
        return taskParameters;
    }
}
