JAVA_LIBRARY(word_rule)

JDK_VERSION(17)

SET(antlr4_input
    ${ARCADIA_ROOT}/crypta/lib/antlr/word_rule/WordRule.g4
)

RUN_JAVA_PROGRAM(
    org.antlr.v4.Tool
    ${antlr4_input}
    -o ${BINDIR}/generated
    -no-listener
    -visitor
    -package ru.yandex.crypta.lib.word.rule
    IN ${antlr4_input}
    OUT_DIR generated
    CLASSPATH contrib/java/org/antlr/antlr4/4.7.1
)

OWNER(
    g:crypta
    g:crypta-lib
)

PEERDIR(
    contrib/java/org/antlr/antlr4/4.7.1
)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.crypta.lib.word.rule
    SRCDIR ${BINDIR}/generated **/*.java
)

JAVA_SRCS(
    SRCDIR ${ARCADIA_ROOT}/crypta/lib/antlr/word_rule **/*
)

INCLUDE(${ARCADIA_ROOT}/crypta/lib/inc/java_without_checks.inc)

END()
