package ru.yandex.crypta.common.ws;

import javax.ws.rs.core.UriBuilder;

import ru.yandex.crypta.common.ws.jersey.ReflectionJerseyResourceConfig;

public abstract class AbstractServer {

    public static final boolean DO_NOT_START = false;
    public static final String HTTP_LOCALHOST = "http://0.0.0.0/";

    private final ReflectionJerseyResourceConfig resourceConfig;
    private final int port;

    protected AbstractServer(ReflectionJerseyResourceConfig resourceConfig, int port) {
        this.resourceConfig = resourceConfig;
        this.port = port;
    }

    public ReflectionJerseyResourceConfig getResourceConfig() {
        return resourceConfig;
    }

    protected UriBuilder getUri() {
        return UriBuilder.fromUri(HTTP_LOCALHOST).port(getPort());
    }

    public abstract void start();

    protected int getPort() {
        return port;
    }
}
